/*
 * Decompiled with CFR 0.152.
 */
package checkerboard;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class MenuItemHandler
implements EventHandler<ActionEvent> {
    private final GraphicsContext gc;
    private final double width;
    private final double height;
    private final int rows;
    private final int columns;

    public MenuItemHandler(Canvas canvas, int rows, int columns) {
        this.gc = canvas.getGraphicsContext2D();
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
        this.rows = rows;
        this.columns = columns;
    }

    public void handle(ActionEvent event) {
        MenuItem item = (MenuItem)event.getSource();
        String id = item.getId();
        if (id.equals("red")) {
            this.gc.setStroke((Paint)Color.RED);
        } else if (id.equals("green")) {
            this.gc.setStroke((Paint)Color.GREEN);
        } else if (id.equals("blue")) {
            this.gc.setStroke((Paint)Color.BLUE);
        }
        this.drawPicture();
    }

    public void drawPicture() {
        double cellWidth = this.width / (double)this.columns;
        double cellHeight = this.height / (double)this.rows;
        this.gc.setLineWidth(4.0);
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.gc.strokeRect(x, y, cellWidth, cellHeight);
                x += cellWidth;
            }
            x = 0.0;
            y += cellHeight;
        }
    }
}

