package checkerboard;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class Checkerboard extends Application {

    private final int WIDTH = 512;
    private final int HEIGHT = 512;
    private final int ROWS = 8;
    private final int COLUMNS = 8;
    private final String TITLE = "Checkerboard";

    @Override
    public void start(Stage stage) {
        // Create an object whose methods control
        // where elements of user interface appear
        // on the screen.
        BorderPane root = new BorderPane();

        // Create a container to hold all elements
        // of the user interface.
        Scene scene = new Scene(root, WIDTH, HEIGHT);
        
        // Create an object to contain a picture.
        Canvas canvas = new Canvas( WIDTH, HEIGHT );
        
        // Create an object that contains a method to
        // respond to selections of menu items.
        MenuItemHandler handler = new MenuItemHandler( canvas, 
                ROWS, COLUMNS);
        
        // Define a menu bar on which menu(s) will be displayed.
        MenuBar menuBar = new MenuBar();
        // Define a menu to attach to the menu bar.
        Menu colors = new Menu("Colors");
        
        // Do you see some repetition in the code below?
        // Do you recognize an opportunity to define a new method?
        MenuItem red = new MenuItem("red");
        red.setId("red");
        red.setOnAction( handler );
   
        MenuItem green = new MenuItem("green");
        green.setId("green");
        green.setOnAction( handler );
        
        MenuItem blue = new MenuItem("blue");
        blue.setId( "blue" );
        blue.setOnAction( handler );
        
        // Add items to a menu.
        colors.getItems().addAll(red, green, blue);
        // Add a menu to the menu bar.
        menuBar.getMenus().add(colors);

        // Place the picture in the middle of the pane.
        root.setCenter( canvas );
        // Place the menubar at the top of the pane.
        root.setTop(menuBar);

        // Draw the picture with the default color.
        handler.drawPicture();

        // Put a title at the top of the window.
        stage.setTitle(TITLE);
        
        // Load and display all elements of
        // our program's user interface---in this
        // case, a menu and a picture.
        stage.setScene(scene);
        stage.show();
    } // start( Stage )

    public static void main(String[] args) {
        // Execution of the program begins here.
        // Get everything started.
        launch(args);
    } // main( String [] )

} // Checkerboard
