package checkerboard;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;
import javafx.scene.paint.Color;

public class MenuItemHandler
        implements EventHandler<ActionEvent> {

    private final GraphicsContext gc;
    private final double width;
    private final double height;
    private final int rows;
    private final int columns;

    public MenuItemHandler(Canvas canvas,
            int rows, int columns ) {
        this.gc = canvas.getGraphicsContext2D();
        this.width = canvas.getWidth();
        this.height = canvas.getHeight();
        this.rows = rows;
        this.columns = columns;
    } // MenuItemHandler( Canvas, int, int )

    @Override
    public void handle(ActionEvent event) {
        // The event parameter carries knowledge
        // of which menu item was selected.
        MenuItem item = (MenuItem) event.getSource();
        String id = item.getId();
        
        // TO-DO: Instead of drawing the outlines
        // of squares, draw filled squares. Alternate
        // colors to make a checkerboard, or vertical
        // stripes, or horizontal stripes, or diagonal
        // stripes, or some other pattern.
        
        // You may choose other colors here.
        if( id.equals( "red") ) {
            gc.setStroke( Color.RED );
        } // if
        else if( id.equals("green")) {
            gc.setStroke( Color.GREEN);
        } // else if
        else if( id.equals("blue")) {
            gc.setStroke( Color.BLUE);
        } // else if
        
        drawPicture();
    } // handle( ActionEvent )

     public void drawPicture() {
        double cellWidth = width / columns;
        double cellHeight = height / rows;

        // You may choose a different width for lines.
        gc.setLineWidth( 4 );
        
        double x = 0;
        double y = 0;
        for (int i = 0; i < rows; i++) {
            for (int j = 0; j < columns; j++) {
                gc.strokeRect(x, y, cellWidth, cellHeight);
                x += cellWidth;
            } // for
            x = 0;
            y += cellHeight;
        } // for
    } // drawPicture()
} // MenuItemHandler
