/*
 * Decompiled with CFR 0.152.
 */
package fractaltriangles;

import fractaltriangles.MenuItemHandler;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class FractalTriangles
extends Application {
    private final int WIDTH = 512;
    private final int HEIGHT = 512;
    private final String TITLE = "Fractal Triangles";

    public void start(Stage stage) {
        BorderPane borderPane = new BorderPane();
        Scene scene = new Scene((Parent)borderPane, 512.0, 512.0);
        Canvas canvas = new Canvas(512.0, 512.0);
        MenuItemHandler handler = new MenuItemHandler(canvas);
        MenuBar menuBar = new MenuBar();
        Menu depthOfRecursion = new Menu("Depth of recursion");
        menuBar.getMenus().add((Object)depthOfRecursion);
        MenuItem depth0 = this.createMenuItem("0", handler);
        MenuItem depth1 = this.createMenuItem("1", handler);
        MenuItem depth2 = this.createMenuItem("2", handler);
        MenuItem depth3 = this.createMenuItem("3", handler);
        MenuItem depth4 = this.createMenuItem("4", handler);
        MenuItem depth5 = this.createMenuItem("5", handler);
        MenuItem depth6 = this.createMenuItem("6", handler);
        depthOfRecursion.getItems().addAll((Object[])new MenuItem[]{depth0, depth1, depth2, depth3, depth4, depth5, depth6});
        borderPane.setTop((Node)menuBar);
        borderPane.setCenter((Node)canvas);
        stage.setTitle("Fractal Triangles");
        stage.setScene(scene);
        stage.show();
    }

    private MenuItem createMenuItem(String name, MenuItemHandler handler) {
        MenuItem result = new MenuItem(name);
        result.setId(name);
        result.setOnAction((EventHandler)handler);
        return result;
    }

    public static void main(String[] args) {
        FractalTriangles.launch((String[])args);
    }
}

