/*
 * Decompiled with CFR 0.152.
 */
package fractaltriangles;

import fractaltriangles.Triangle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.MenuItem;

public class MenuItemHandler
implements EventHandler<ActionEvent> {
    private final Canvas canvas;
    private final GraphicsContext gc;

    public MenuItemHandler(Canvas canvas) {
        this.canvas = canvas;
        this.gc = canvas.getGraphicsContext2D();
    }

    public void handle(ActionEvent event) {
        MenuItem menuItem = (MenuItem)event.getSource();
        String id = menuItem.getId();
        int depth = Integer.parseInt(id);
        this.draw(depth);
    }

    private void draw(int depth) {
        double width = this.canvas.getWidth();
        double height = this.canvas.getHeight();
        double centerX = width / 2.0;
        double centerY = height / 2.0;
        double radius = Math.min(width, height) / 3.0;
        Triangle t = new Triangle(centerX, centerY, radius);
        this.gc.clearRect(0.0, 0.0, width, height);
        t.subdivide(this.gc, depth);
    }
}

