/*
 * Decompiled with CFR 0.152.
 */
package fractaltriangles;

import javafx.geometry.Point2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class Triangle {
    private final Point2D southwestVertex;
    private final Point2D southeastVertex;
    private final Point2D northVertex;

    public Triangle(double centerX, double centerY, double radius) {
        double angle = Math.toRadians(330.0);
        double x = centerX + radius * Math.cos(angle);
        double y = centerY + radius * Math.sin(angle);
        this.southwestVertex = new Point2D(x, y);
        angle = Math.toRadians(90.0);
        x = centerX + radius * Math.cos(angle);
        y = centerY + radius * Math.sin(angle);
        this.southeastVertex = new Point2D(x, y);
        angle = Math.toRadians(210.0);
        x = centerX + radius * Math.cos(angle);
        y = centerY + radius * Math.sin(angle);
        this.northVertex = new Point2D(x, y);
    }

    public Triangle(Point2D se, Point2D n, Point2D sw) {
        this.southeastVertex = se;
        this.northVertex = n;
        this.southwestVertex = sw;
    }

    public void draw(GraphicsContext gc) {
        double[] xCoordinates = new double[3];
        double[] yCoordinates = new double[3];
        xCoordinates[0] = this.southeastVertex.getX();
        xCoordinates[1] = this.northVertex.getX();
        xCoordinates[2] = this.southwestVertex.getX();
        yCoordinates[0] = this.southeastVertex.getY();
        yCoordinates[1] = this.northVertex.getY();
        yCoordinates[2] = this.southwestVertex.getY();
        gc.setStroke((Paint)Color.BLACK);
        gc.strokePolygon(xCoordinates, yCoordinates, 3);
    }

    public Triangle southeastTriangle() {
        Point2D se = this.southeastVertex;
        Point2D n = this.midpoint(this.southeastVertex, this.northVertex);
        Point2D sw = this.midpoint(this.southeastVertex, this.southwestVertex);
        return new Triangle(se, n, sw);
    }

    public Triangle northTriangle() {
        Point2D se = this.midpoint(this.northVertex, this.southeastVertex);
        Point2D n = this.northVertex;
        Point2D sw = this.midpoint(this.northVertex, this.southwestVertex);
        return new Triangle(se, n, sw);
    }

    public Triangle southwestTriangle() {
        Point2D se = this.midpoint(this.southwestVertex, this.southeastVertex);
        Point2D n = this.midpoint(this.southwestVertex, this.northVertex);
        Point2D sw = this.southwestVertex;
        return new Triangle(se, n, sw);
    }

    public void subdivide(GraphicsContext gc, int depth) {
        if (depth < 1) {
            this.draw(gc);
        } else {
            this.southeastTriangle().subdivide(gc, depth - 1);
            this.northTriangle().subdivide(gc, depth - 1);
            this.southwestTriangle().subdivide(gc, depth - 1);
        }
    }

    public Point2D midpoint(Point2D p0, Point2D p1) {
        double x = (p0.getX() + p1.getX()) / 2.0;
        double y = (p0.getY() + p1.getY()) / 2.0;
        return new Point2D(x, y);
    }
}

