package fractaltriangles;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class FractalTriangles extends Application {

    private final int WIDTH = 512;
    private final int HEIGHT = 512;
    private final String TITLE = "Fractal Triangles";

    @Override
    public void start(Stage stage) {
        BorderPane borderPane = new BorderPane();
        Scene scene = new Scene(borderPane, WIDTH, HEIGHT);
        Canvas canvas = new Canvas(WIDTH, HEIGHT);

        MenuItemHandler handler = new MenuItemHandler(canvas);

        MenuBar menuBar = new MenuBar();
        Menu depthOfRecursion = new Menu("Depth of recursion");
        menuBar.getMenus().add(depthOfRecursion);

        MenuItem depth0 = createMenuItem("0", handler);
        MenuItem depth1 = createMenuItem("1", handler);
        MenuItem depth2 = createMenuItem("2", handler);
        MenuItem depth3 = createMenuItem("3", handler);
        MenuItem depth4 = createMenuItem("4", handler);
        MenuItem depth5 = createMenuItem("5", handler);
        MenuItem depth6 = createMenuItem("6", handler);
        depthOfRecursion.getItems().addAll(
                depth0,
                depth1,
                depth2,
                depth3,
                depth4,
                depth5,
                depth6);

        borderPane.setTop( menuBar );
        borderPane.setCenter(canvas);

        stage.setTitle(TITLE);
        stage.setScene(scene);
        stage.show();
    } // start( Stage )

    private MenuItem createMenuItem(String name,
            MenuItemHandler handler) {
        MenuItem result = new MenuItem(name);
        result.setId(name);
        result.setOnAction(handler);
        return result;
    } // createMenuItem( String )

    public static void main(String[] args) {
        launch(args);
    } // main( String [] )

} // FractalTriangles
