package algorithms;

public class Algorithms {

    /**
     * This is the largest value that the constructor that fills the data array
     * with random numbers will put in the array.
     */
    private final int MAX_VALUE = 99;

    /**
     * This is array in which the methods will search and the array it will
     * sort.
     */
    private final int[] data;

    /**
     * This constructor will fill the data array with random integers in the
     * range 0 to MAX_VALUE.
     *
     * @param size is the number of random integers that this constructor will
     * place in the data array.
     */
    public Algorithms(int size) {
        this.data = new int[size];
        for (int i = 0; i < size; i++) {
            this.data[i] = (int) (Math.random() * (MAX_VALUE + 1));
        } // for
    } // Algorithms( int )

    /**
     * This constructor will fill the data array with given values.
     *
     * @param values are the integers to be copied into the data array.
     */
    public Algorithms(int[] values) {
        this.data = new int[values.length];
        for (int i = 0; i < values.length; i++) {
            this.data[i] = values[i];
        } // for
    } // Algorithms( int [] )

    /**
     * This accessor return the integer that is at a specified position in the
     * data array.
     *
     * @param index is the position of the integer that is to be returned in the
     * data array.
     * @return the integer found at the specified position in the data array.
     */
    public int get(int index) {
        // TO-DO: complete this stub method.
        return 0;
    } // get(int )

    /**
     * This mutator replaces the value found at a given position in the data
     * array with a new value.
     *
     * @param index is the position of the element in the data array whose value
     * is to be changed.
     * @param value is the new value to be stored in the given position in the
     * data array.
     */
    public void set(int index, int value) {
        // TO-DO: complete this stub method.
    } // set( int, int )

    /**
     * This method exchanges the values at two specified positions in the data
     * array.
     *
     * @param i is the index of one element of the data array.
     * @param j is the index of the other element of the data array.
     */
    public void swap(int i, int j) {
        // TO-DO: complete this stub method.
    } // swap( int, int )

    /**
     * This method returns the value of the smallest element in the data array.
     *
     * @return the smallest element found in the data array.
     */
    public int minimumValue() {
        // TO-DO: complete this stub method.
        return 0;
    } // minimumValue()

    /**
     * This method returns the position (index) of the smallest value in the
     * data array.
     *
     * @return the position of the smallest value in the data array.
     */
    public int positionOfMinimumValue() {
        // TO-DO: complete this stub method.
        return 0;
    } // positionOfMinimumValue()

    /**
     * Return the position of the smallest element found in that part of the
     * data array that begins at a specified position.
     *
     * @param startingIndex is the position at which to begin the search for the
     * smallest element.
     * @return the position (index) of the smallest element in the specified
     * part of the data array.
     */
    public int positionOfMinimumValue(int startingIndex) {
        // TO-DO: complete this stub method.
        return 0;
    } // positionOfMinimumValue( int )

    /**
     * Sort the elements of the data array.
     */
    public void selectionSort() {
        // TO-DO: complete this stub method.
    } // selectionSort()

    /**
     * Print the elements of the data array.
     */
    public void printData() {
        for (int i = 0; i < this.data.length; i++) {
            System.out.printf("%02d ", this.get(i));
            if (i > 0 && (i + 1) % 20 == 0) {
                System.out.println();
            } // if
        } // for
    } // printData()

    public static void main(String[] args) {
        Algorithms a = new Algorithms(48);
        a.printData();
    } // main( String [] )

} // Algorithms
