package algorithms;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

public class AlgorithmsTest {

    public AlgorithmsTest() {
    } // AlgorithmsTest()

    @Test
    public void testGet() {
        int index = 2;
        int[] nums = {5, 2, 3, 1, 4};
        Algorithms instance = new Algorithms(nums);
        int expResult = 3;
        int result = instance.get(index);
        assertEquals(expResult, result);
    } // testGet()

    @Test
    public void testSet() {
        int index = 2;
        int value = 99;
        int[] nums = {5, 2, 3, 1, 4};
        Algorithms instance = new Algorithms(nums);
        instance.set(index, value);
        int expResult = 99;
        int result = instance.get(index);
        assertEquals(result, expResult);
    } // testSet()

    @Test
    public void testSwap() {
        int[] nums = {5, 2, 3, 1, 4};
        Algorithms instance = new Algorithms(nums);
        int i = 1;
        int j = 4;
        instance.swap(i, j);
        int expResult = 4;
        int result = instance.get(i);
        assertEquals(result, expResult);
        expResult = 2;
        result = instance.get(4);
        assertEquals(result, expResult);
    } // testSwap()

    @Test
    public void testMinimumValue() {
        int[] nums = {5, 2, 3, 1, 4};
        Algorithms instance = new Algorithms(nums);
        int expResult = 1;
        int result = instance.minimumValue();
        assertEquals(expResult, result);
    } // testMinimumValue()

    @Test
    public void testPositionOfMinimumValue_0args() {
        int[] nums = {5, 2, 3, 1, 4};
        Algorithms instance = new Algorithms(nums);
        int expResult = 3;
        int result = instance.positionOfMinimumValue();
        assertEquals(expResult, result);
    } // testPositionOfMinimumValue_0args()

    @Test
    public void testPositionOfMinimumValue_int() {
        int startingIndex = 2;
        int [] nums = {4, 1, 3, 2, 5};
        Algorithms instance = new Algorithms(nums);
        int expResult = 3;
        int result = instance.positionOfMinimumValue(startingIndex);
        assertEquals(expResult, result);
    } // testPositionOfMinimumValue_int()

    @Test
    public void testSelectionSort() {
        int [] nums = {5, 2, 3, 1, 4};
        Algorithms instance = new Algorithms(nums);
        instance.selectionSort();
        int expResult = 1;
        int result = instance.get(0);
        assertEquals( result, expResult );
        expResult = 2;
        result = instance.get(1);
        assertEquals( result, expResult );
        expResult = 3;
        result = instance.get(2);
        assertEquals( result, expResult );
        expResult = 4;
        result = instance.get(3);
        assertEquals( result, expResult );
        expResult = 5;
        result = instance.get(4);
        assertEquals( result, expResult );
    } // testSelectionSort()

} // AlgorithmsTest
