package bst;

import java.util.Random;
/**
 * 
 * @author Asher
 */
public class BST {

    private final Node root;

    public BST(int value) {
        this.root = new Node(value, null, null);
    } // BST( int )

    public void add(int value) {
        addHelper(value, this.root);
    } // add( int )

    public void addHelper(int value, Node node) {
        if (value == node.getValue()) {
            // do nothing --- add no duplicate elements
        } // if
        else if (value < node.getValue()) {
            if (node.getLeftChild() == null) {
                Node child = new Node(value, null, null);
                node.setLeftChild(child);
            } // if
            else {
                addHelper(value, node.getLeftChild());
            } // else
        } else // value must be > node.getValue()
        if (node.getRightChild() == null) {
            Node child = new Node(value, null, null);
            node.setRightChild(child);
        } // if
        else {
            addHelper(value, node.getRightChild());
        } // else
    } // addHelper( int, Node )
    
    public void printHelper( Node node ) {
        if( node != null ) {
            printHelper( node.getLeftChild());
            System.out.println( node.getValue());
            printHelper( node.getRightChild());
        } // if
    } // printHelper( Node )

    public void print() {
        printHelper( this.root );
    } // print()
    
    public static void main(String[] args) {
        Random rng = new Random();

        int n = rng.nextInt(100);
        System.out.println(n);
        BST tree = new BST(n);
        for (int i = 0; i < 16; i++) {
            n = rng.nextInt(100);
            System.out.println(n);
            tree.add( n );
        } // for
        
        System.out.println();
        
        tree.print();
    } // main( String [] )

} // BST
