package apollo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Apollo implements Comparable<Apollo> {

    private final int flightNumber;
    private final String CSMName;
    private final String LMName;

    public Apollo(int number, String CSMName, String LMName) {
        this.flightNumber = number;
        this.CSMName = CSMName;
        this.LMName = LMName;
    } // Apollo()

    public static void main(String[] args) {
        List<Apollo> flights = new ArrayList<>();

        flights.add( new Apollo( 9, "Gumdrop", "Spider"));
        flights.add( new Apollo( 10, "Charlie Brown", "Snoopy"));
        flights.add( new Apollo( 11, "Columbia", "Eagle"));
        flights.add( new Apollo( 12, "Yankee Clipper", "Intrepid"));
        flights.add( new Apollo( 13, "Odyssey", "Aquarius"));
        
        Collections.sort( flights );
        
        for( Apollo mission : flights ) {
            System.out.println( mission );
        } // for
        
    } // main( String [] )

    public int getFlightNumber() {
        return flightNumber;
    }

    public String getCSMName() {
        return CSMName;
    }

    public String getLMName() {
        return LMName;
    }

    @Override
    public String toString() {
        return "Apollo "
                + this.getFlightNumber() + " "
                + this.getCSMName() + ", "
                + this.getLMName();
    } // toString()

    @Override
    public int compareTo(Apollo mission) {
        return this.getLMName().compareTo(mission.getLMName());
        
    } // compareTo( Apollo )

} // Apollo
