/*
 * Decompiled with CFR 0.152.
 */
package news;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import news.MenuItemHandler;
import news.Story;

public class NewsReader
extends Application {
    private final int WIDTH = 768;
    private final int HEIGHT = 512;
    private final List<Story> stories = new ArrayList<Story>();
    private final Random rng = new Random();
    private final String DEUTSCHE_WELLE_NAME = "Deutsche Welle";
    private final String DEUTSCHE_WELLE_URL = "http://rss.dw.com/xml/rss-de-deutschlandentdecken";
    private final String GOETHE_INSTITUT_NAME = "Goethe Institut";
    private final String GOETHE_INSTITUT_URL = "https://www.goethe.de/de/feed/kul.rss";
    private final String HELMHOLTZ_ASSOC_NAME = "Helmholtz Association";
    private final String HELMHOLTZ_ASSOC_URL = "https://www.helmholtz.de/aktuell/presse_und_medien/mediathek/rss_feeds/technologie/";
    private final String SUEDDEUTSCHE_ZEITUNG_NAME = "S\u00fcddeutsche Zeitung";
    private final String SUEDDEUTSCHE_ZEITUNG_URL = "http://rss.sueddeutsche.de/rss/Topthemen";
    private final String PRONOUNS_NAME = "Pronouns";
    private final String PRONOUNS_ID = "Pronouns";
    private final String DEF_ARTICLES_NAME = "Definite articles";
    private final String DEF_ARTICLES_ID = "Definite articles";
    private final String INDEF_ARTICLES_NAME = "Indefinite articles";
    private final String INDEF_ARTICLES_ID = "Indefinite articles";
    private final String PREPOSITIONS_NAME = "Prepositions";
    private final String PREPOSITIONS_ID = "Prepositions";
    private final String DEFINITE_ARTICLES = "das|den|dem|der|die";
    private final String INDEFINITE_ARTICLES = "ein|einem|einen|einer|kein|keinem|keinen|keiner";
    private final String PRONOUNS = "er|es|ihn|ihm|ihr|sie|uns|wir";
    private final VBox vBox = new VBox(18.0);

    public void init() {
        this.readChannel("http://rss.sueddeutsche.de/rss/Topthemen");
    }

    public void start(Stage stage) {
        BorderPane topLevel = new BorderPane();
        topLevel.getStyleClass().add((Object)"border-pane");
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.getStyleClass().add((Object)"scroll-pane");
        this.vBox.setPrefWidth(768.0);
        this.vBox.getStyleClass().add((Object)"vbox-flow");
        scrollPane.setContent((Node)this.vBox);
        topLevel.setCenter((Node)scrollPane);
        MenuItemHandler handler = new MenuItemHandler(this);
        MenuBar menuBar = new MenuBar();
        Menu channels = new Menu("Channel");
        menuBar.getMenus().add((Object)channels);
        MenuItem channel0 = this.createMenuItem("Deutsche Welle", "http://rss.dw.com/xml/rss-de-deutschlandentdecken", handler);
        MenuItem channel1 = this.createMenuItem("Goethe Institut", "https://www.goethe.de/de/feed/kul.rss", handler);
        MenuItem channel2 = this.createMenuItem("Helmholtz Association", "https://www.helmholtz.de/aktuell/presse_und_medien/mediathek/rss_feeds/technologie/", handler);
        MenuItem channel3 = this.createMenuItem("S\u00fcddeutsche Zeitung", "http://rss.sueddeutsche.de/rss/Topthemen", handler);
        channels.getItems().addAll((Object[])new MenuItem[]{channel0, channel1, channel2, channel3});
        Menu partsOfSpeech = new Menu("Parts of speech");
        menuBar.getMenus().add((Object)partsOfSpeech);
        MenuItem part0 = this.createMenuItem("Definite articles", "Definite articles", handler);
        MenuItem part1 = this.createMenuItem("Indefinite articles", "Indefinite articles", handler);
        MenuItem part2 = this.createMenuItem("Prepositions", "Prepositions", handler);
        MenuItem part3 = this.createMenuItem("Pronouns", "Pronouns", handler);
        partsOfSpeech.getItems().addAll((Object[])new MenuItem[]{part0, part1, part2, part3});
        topLevel.setTop((Node)menuBar);
        Scene scene = new Scene((Parent)topLevel, 768.0, 512.0);
        scene.getStylesheets().add((Object)NewsReader.class.getResource("NewsReader.css").toExternalForm());
        stage.setTitle("Nachrichten aus Deutschland");
        stage.setScene(scene);
        stage.show();
    }

    private MenuItem createMenuItem(String name, String url, MenuItemHandler handler) {
        MenuItem result = new MenuItem(name);
        result.setId(url);
        result.setOnAction((EventHandler)handler);
        return result;
    }

    public void readChannel(String url) {
        boolean ok = false;
        try {
            URL feedUrl = new URL(url);
            SyndFeedInput input = new SyndFeedInput();
            XmlReader reader = new XmlReader(feedUrl);
            SyndFeed feed = input.build(reader);
            this.stories.clear();
            for (Object o : feed.getEntries()) {
                if (!(o instanceof SyndEntryImpl)) continue;
                SyndEntryImpl e = (SyndEntryImpl)o;
                String[] title = e.getTitle();
                String description = e.getDescription().getValue();
                String link = e.getLink();
                description = description.replaceAll("<p>|</p>", "");
                Story story = new Story((String)title, description, link);
                this.stories.add(story);
            }
            ok = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("ERROR: " + ex.getMessage());
        }
        if (!ok) {
            System.out.println();
            System.out.println("FeedReader reads and prints any RSS/Atom feed type.");
            System.out.println("The first parameter must be the URL of the feed to read.");
            System.out.println();
        }
        this.vBox.getChildren().clear();
        for (Story story : this.stories) {
            TextFlow titleFlow = new TextFlow();
            Text title = new Text(story.getTitle());
            titleFlow.getChildren().add((Object)title);
            title.getStyleClass().add((Object)"story-title");
            TextFlow descriptionFlow = new TextFlow();
            ObservableList children = descriptionFlow.getChildren();
            String sentence = story.getDescription();
            for (String word : sentence.split(" ")) {
                Text descriptionWord = new Text(word + " ");
                if (word.toLowerCase().matches("das|den|dem|der|die")) {
                    descriptionWord.getStyleClass().add((Object)"definite-article");
                } else if (word.toLowerCase().matches("ein|einem|einen|einer|kein|keinem|keinen|keiner")) {
                    descriptionWord.getStyleClass().add((Object)"indefinite-article");
                } else {
                    descriptionWord.getStyleClass().add((Object)"story-description");
                }
                children.add((Object)descriptionWord);
            }
            descriptionFlow.setPrefWidth(384.0);
            VBox storyBox = new VBox(6.0);
            storyBox.getChildren().addAll((Object[])new Node[]{titleFlow, descriptionFlow});
            this.vBox.getChildren().add((Object)storyBox);
        }
    }

    public static void main(String[] args) {
        NewsReader.launch((String[])args);
    }
}

