package com.example.xylophone;

import android.content.res.ColorStateList;
import android.media.SoundPool;
import android.os.Bundle;
import android.os.Handler;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

public class MainActivity extends AppCompatActivity {

    // Constants
    private static final int SIM_SOUND = 8;
    private static final float LEFT_VOLUME = 1.0f;
    private static final float RIGHT_VOLUME = 1.0f;
    private static final int LOOP = 0;
    private static final int PRIORITY = 0;
    private static final float NORMAL_PLAY_RATE = 1.0f;

    // SoundPool instance
    private SoundPool mSoundPool;

    // Sound IDs
    private int mCSoundId1, mDSoundId2, mESoundId3, mFSoundId4;
    private int mGSoundId5, mASoundId6, mBSoundId7, mc2SoundId8;

    //Note Counter
    private int noteCount = 0;
    private TextView noteCounterText;
    private Button[] noteButtons;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Initialize SoundPool
        mSoundPool = new SoundPool.Builder()
                .setMaxStreams(SIM_SOUND)
                .build();

        // Initialize elements
        //TextView
        noteCounterText = findViewById(R.id.note_counter);
        //Buttons
        Button cButton = findViewById(R.id.c_key);
        Button dButton = findViewById(R.id.d_key);
        Button eButton = findViewById(R.id.e_key);
        Button fButton = findViewById(R.id.f_key);
        Button gButton = findViewById(R.id.g_key);
        Button aButton = findViewById(R.id.a_key);
        Button bButton = findViewById(R.id.b_key);
        Button c2Button = findViewById(R.id.c2_key);

        noteButtons = new Button[] {cButton, dButton, eButton, fButton, gButton, aButton, bButton, c2Button};

        // Load sound files
        mCSoundId1 = mSoundPool.load(this, R.raw.note1_c, 1);
        mDSoundId2 = mSoundPool.load(this, R.raw.note2_d, 1);
        mESoundId3 = mSoundPool.load(this, R.raw.note3_e, 1);
        mFSoundId4 = mSoundPool.load(this, R.raw.note4_f, 1);
        mGSoundId5 = mSoundPool.load(this, R.raw.note5_g, 1);
        mASoundId6 = mSoundPool.load(this, R.raw.note6_a, 1);
        mBSoundId7 = mSoundPool.load(this, R.raw.note7_b, 1);
        mc2SoundId8 = mSoundPool.load(this, R.raw.note8_c2, 1);

        // Set onClickListeners for buttons
        cButton.setOnClickListener(v -> playNote(mCSoundId1));
        dButton.setOnClickListener(v -> playNote(mDSoundId2));
        eButton.setOnClickListener(v -> playNote(mESoundId3));
        fButton.setOnClickListener(v -> playNote(mFSoundId4));
        gButton.setOnClickListener(v -> playNote(mGSoundId5));
        aButton.setOnClickListener(v -> playNote(mASoundId6));
        bButton.setOnClickListener(v -> playNote(mBSoundId7));
        c2Button.setOnClickListener(v -> playNote(mc2SoundId8));
    }

    private void playNote(int soundId) {
        mSoundPool.play(soundId, LEFT_VOLUME, RIGHT_VOLUME, PRIORITY, LOOP, NORMAL_PLAY_RATE);
        noteCount++;
        noteCounterText.setText(String.valueOf(noteCount));
        if(noteCount >= 5 && noteCount <10){
            for (Button button : noteButtons) {
                this.setBackgroundColor(button, R.color.green_2);
            }
        } else if(noteCount >= 10 && noteCount <15){
            for (Button button : noteButtons) {
                this.setBackgroundColor(button, R.color.green_3);
            }
        }
        else if(noteCount >= 15 && noteCount <20){
            for (Button button : noteButtons) {
                this.setBackgroundColor(button, R.color.green_4);
            }
        }
        else if(noteCount >= 20){

            for (Button button : noteButtons) {
                button.setEnabled(false);
                this.setBackgroundColor(button, R.color.purple_8);
            }

            Toast.makeText(this, "Congrats! You played 20 notes!", Toast.LENGTH_SHORT).show();

            // Auto-reset after 3 seconds
            new Handler().postDelayed(this::resetApp, 3000);
        }
    }

    private void resetApp() {
        noteCount = 0;
        noteCounterText.setText(String.valueOf(noteCount));

        for (Button button : noteButtons) {
            button.setEnabled(true);
            this.setBackgroundColor(button, R.color.green_1);
        }
    }

    /** @noinspection deprecation*/
    private void setBackgroundColor(Button btn, int colorId){
        btn.setBackgroundTintList(ColorStateList.valueOf(getResources().getColor(colorId)));
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mSoundPool != null) {
            mSoundPool.release();
            mSoundPool = null;
        }
    }
}