
package roster;

public class Student implements Comparable<Student> {
    private final String firstName;
    private final String lastName;
    private final String email;
    
    public Student( String firstName, String lastName,
            String email ) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
    } // Student( String, String, String )

    public String getFirstName() {
        return firstName;
    } // getFirstName()

    public String getLastName() {
        return lastName;
    } // getLastName()

    public String getEmail() {
        return email;
    } // getEmail()

    @Override
    public int compareTo(Student otherStudent) {
        String ownLastName = this.getLastName();
        String otherLastName = otherStudent.getLastName();
        String ownFirstName = this.getFirstName();
        String otherFirstName = otherStudent.getFirstName();
        
        if( ownLastName.equals(otherLastName)) {
            return ownFirstName.compareTo(otherFirstName);
        } // if
        else {
            return ownLastName.compareTo(otherLastName);
        } // else
    } // compareTo( Student )
    
} // Student
