package roster;

import java.util.Collections;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextArea;

public class TopButtonHandler
        implements EventHandler<ActionEvent> {

    private final List<Student> students;
    private final TextArea pad;

    public TopButtonHandler(List<Student> students,
            TextArea pad) {
        this.students = students;
        this.pad = pad;
    } // TopButtonHandler( List<Student>, TextArea )

    @Override
    public void handle(ActionEvent e) {
        pad.clear();
        Collections.shuffle(students);
        for (Student s : students) {
            pad.appendText(s.getFirstName() + " "
                    + s.getLastName() + "\n\n");
        } // for
    } // handle(ActionEvent)
} // TopButtonHandler

