package roster;

import java.util.List;
import java.util.Random;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.TextArea;

public class BottomButtonHandler
        implements EventHandler<ActionEvent> {

    private final List<Student> students;
    private final TextArea pad;
    private final Random rng;

    public BottomButtonHandler(List<Student> students,
            TextArea pad) {
        this.students = students;
        this.pad = pad;
        this.rng = new Random();
    } // BottomButtonHandler( List<Student>, TextArea )

    @Override
    public void handle(ActionEvent e) {
        pad.clear();
        int index = rng.nextInt(students.size());
        Student s = students.get(index);
        pad.appendText(s.getFirstName() + " "
                + s.getLastName() + "\n");
    } // handle(ActionEvent)
} // BottomButtonHandler
