package roster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javafx.application.Application;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;

public class Roster extends Application {

    private final List<Student> classList
            = new ArrayList<>();
    private final Random rng = new Random();

    @Override
    public void init() {
        classList.add(
                new Student("Ben", "Smith", "bsmith20@cornellcollege.edu"));
        classList.add(
                new Student("Drak", "Twining", "dtwining21@cornellcollege.edu"));
        classList.add(
                new Student("Amber", "Frazier", "afrazier20@cornellcollege.edu"));
        classList.add(
                new Student("Angel", "Fabila", "afabila21@cornellcollege.edu"));
        classList.add(
                new Student("Brody", "Lamb", "blamb19@cornellcollege.edu"));
        classList.add(
                new Student("Asher", "Muse", "amuse21@cornellcollege.edu"));
        classList.add(
                new Student("Dan", "Heinsch", "dheinsch21@cornellcollege.edu"));
        classList.add(
                new Student("Tori", "Giordano", "vgiordano19@cornellcollege.edu"));
        classList.add(
                new Student("Taylor", "Axelson", "taxelson19@cornellcollege.edu"));
        classList.add(
                new Student("Sloane", "Bertelme", "sbartelme19@cornellcollege.edu"));
        classList.add(
                new Student("Owen", "Egolf", "oegolf20@cornellcollege.edu"));
        classList.add(
                new Student("Nick", "O'Keefe", "nokeefe21@cornellcollege.edu"));
        classList.add(
                new Student("Aden", "Twichell", "atwichell21@cornellcollege.edu"));
        classList.add(
                new Student("Jillian", "Shew", "jshew20@cornellcollege.edu"));
        classList.add(
                new Student("Joseph", "Bloom", "jbloom18@cornellcollege.edu"));
        classList.add(
                new Student("Armani", "Rogers", "arogers21@cornellcollege.edu"));
        classList.add(
                new Student("Marshall", "Hobson-Ritz", "mhobsonritz18@cornellcollege.edu"));
        classList.add(
                new Student("Noah", "Carpenter", "ncarpenter20@cornellcollege.edu"));
        classList.add(
                new Student("Matt", "Stoll", "mstoll20@cornellcollege.edu"));
        classList.add(
                new Student("Kean", "Johansen", "kjohansen19@cornellcollege.edu"));
        classList.add(
                new Student("Cullen", "Yuska", "cyuska20@cornellcollege.edu"));
        classList.add(
                new Student("Kaley", "Forster", "kforster21@cornellcollege.edu"));
        classList.add(
                new Student("Cameron", "King", "cking21@cornellcollege.edu"));
        classList.add(
                new Student("Makoto", "Ono", "mono20@cornellcollege.edu"));
        classList.add(
                new Student("Jonah", "Storr", "jstorr21@cornellcollege.edu"));
        classList.add(
                new Student("Ben", "Soderberg", "bsoderberg21@cornellcollege.edu"));
        classList.add(
                new Student("Tim", "Haynes", "thaynes19@cornellcollege.edu"));
        classList.add(
                new Student("Jan", "Siegien", "jsiegen19@cornellcollege.edu"));
        Collections.sort(classList);
    } // Roster()

    @Override
    public void start(Stage stage) {
        TextArea textArea = new TextArea();
        textArea.setEditable(false);
        for (Student s : classList) {
            textArea.appendText(s.getFirstName() + " "
                    + s.getLastName() + "\n\n");
        } // for

        BorderPane topLevel = new BorderPane();
        topLevel.getStyleClass().add("border-pane");
        
        topLevel.setCenter(textArea);

        Button topButton = new Button("All names");
        Button bottomButton = new Button("One Name");

        BorderPane.setAlignment(topButton, Pos.CENTER);
        BorderPane.setAlignment(bottomButton, Pos.CENTER);

        topButton.setId("topButton");
        bottomButton.setId("bottomButton");

        topLevel.setTop(topButton);
        topLevel.setBottom(bottomButton);

        TopButtonHandler tbh = 
                new TopButtonHandler( classList, textArea );
        topButton.setOnAction( tbh );

        BottomButtonHandler bbh = 
                new BottomButtonHandler( classList, textArea );
        bottomButton.setOnAction( bbh );

        Scene scene = new Scene(topLevel, 512, 512);
        scene.getStylesheets().add(
                Roster.class
                        .getResource("Roster.css")
                        .toExternalForm());

        stage.setTitle("CSC144 Software Architecture");
        stage.setScene(scene);
        stage.show();
    } // start( Stage )

    public static void main(String[] args) {
        launch(args);
    } // main( String [] )

} // Roster
