/*
 * Decompiled with CFR 0.152.
 */
package bitmap;

import bitmap.Point;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.PixelWriter;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Bitmap
extends Application {
    private static final int WIDTH = 512;
    private static final int HEIGHT = 512;

    public void start(Stage stage) {
        stage.setTitle("Bitmap");
        Canvas canvas = new Canvas(512.0, 512.0);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        Pane root = new Pane();
        root.getChildren().add((Object)canvas);
        PixelWriter pw = gc.getPixelWriter();
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Color c = this.computeColor(i, j);
                pw.setColor(j, i, c);
            }
        }
        Scene scene = new Scene((Parent)root);
        stage.setScene(scene);
        stage.show();
    }

    private Color computeColor(int row, int column) {
        double y;
        Point p = new Point(row, column, 512, 512);
        double x = p.getX();
        if (x < (y = p.getY())) {
            return Color.WHITE;
        }
        return Color.PURPLE;
    }

    public static void main(String[] args) {
        Bitmap.launch((String[])args);
    }
}

