package bitmap;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.PixelWriter;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

/**
 * This is an experiment with bit-mapped graphics.
 * 
 * You may include HTML in your Javadoc comments.
 * 
 * <h1>Section Title</h1>
 * 
 * Here is an enumerated list.
 * <ol>
 * <li> int </li>
 * <li> double </li>
 * <li> boolean </li>
 * </ol>
 * 
 * <h2>Subsection Title</h2>
 * 
 * Here is an itemized list.
 * <ul>
 * <li> for loop </li>
 * <li> enhanced for loop (for-each loop) </li>
 * <li> while loop </li>
 * <li> if statement </li>
 * <li> switch statement </li>
 * </ul>
 * 
 * <p>
 * To learn more about the man who led the
 * team that created the Java programming language,
 * take a look at 
 * <a href="https://en.wikipedia.org/wiki/James_Gosling">
 * this article on Wikipedia.
 * </a>
 * </p>
 * 
 * <p>
 * The University of Minnesota is the home
 * of an archive that holds documents related to the
 * history of computing.
 * It is the Charles Babbage Institute.
 * </p>
 * 
 * <img src="https://upload.wikimedia.org/wikipedia/commons/d/d1/Elmer_Andersen_Library_Minnesota_5.jpg"
 * alt="Charles Babbage Institute"
 * width=384>
 * 
 * <p>
 * This photograph is
 * by AlexiusHoratius (Own work) [CC BY-SA 3.0 (https://creativecommons.org/licenses/by-sa/3.0) or GFDL (http://www.gnu.org/copyleft/fdl.html)], via Wikimedia Commons
 * </p>
 * 
 * @author Your Name
 * @version 21 March 2018
 */
public class Bitmap extends Application {

    private static final int WIDTH = 512;
    private static final int HEIGHT = 512;

    @Override
    public void start(Stage stage) {
        stage.setTitle("Bitmap");

        Canvas canvas = new Canvas(WIDTH, HEIGHT);
        GraphicsContext gc = canvas.getGraphicsContext2D();

        Pane root = new Pane();

        root.getChildren().add(canvas);

        PixelWriter pw = gc.getPixelWriter();

        for (int i = 0; i < HEIGHT; i++) {
            for (int j = 0; j < WIDTH; j++) {

                Color c = computeColor( i, j );
                pw.setColor( j, i, c);
            } // for
        } // for

        Scene scene = new Scene(root);
        stage.setScene(scene);

        stage.show();
    } // start( Stage )

    private Color computeColor(int row, int column) {
        Point p = new Point(row, column, HEIGHT, WIDTH);

        double x = p.getX();
        double y = p.getY();

        if (x < y) {
            return Color.WHITE;
        } // if
        else {
            return Color.PURPLE;
        } // else
    } // computeColor( int , int )

    public static void main(String[] args) {
        launch(args);
    } // main( String[] )

} // Bitmap
