/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import fractal.Complex;
import fractal.Palette;
import fractal.Point;
import javafx.application.Application;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.PixelWriter;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Bitmap
extends Application {
    private static final double XMIN = -0.75;
    private static final double XMAX = -0.25;
    private static final double YMIN = 0.25;
    private static final double YMAX = 0.75;
    private static final int WIDTH = 512;
    private static final int HEIGHT = 512;
    private static final int MAX_ITERATIONS = 64;
    private final Palette palette = new Palette(64);

    public void start(Stage stage) {
        stage.setTitle("Fractal Image");
        Canvas canvas = new Canvas(512.0, 512.0);
        GraphicsContext gc = canvas.getGraphicsContext2D();
        Pane root = new Pane();
        root.getChildren().add((Object)canvas);
        PixelWriter pw = gc.getPixelWriter();
        for (int i = 0; i < 512; ++i) {
            for (int j = 0; j < 512; ++j) {
                Color c = this.computeColor(i, j);
                pw.setColor(j, i, c);
            }
        }
        Scene scene = new Scene((Parent)root);
        stage.setScene(scene);
        stage.show();
    }

    private int computeColorIndex(int row, int column) {
        int count;
        Point p = new Point(row, column, 512, 512);
        double x = p.getX();
        double y = p.getY();
        x = -0.75 + 0.5 * (x + 1.0) / 2.0;
        y = 0.25 + 0.5 * (y + 1.0) / 2.0;
        Complex z = new Complex(0.0, 0.0);
        Complex c = new Complex(x, y);
        for (count = 0; z.magnitudeSquared() < 4.0 && count < 63; ++count) {
            z = z.multiply(z);
            z = z.add(c);
        }
        return count;
    }

    public Color computeColor(int row, int column) {
        int i = this.computeColorIndex(row, column);
        return this.palette.getColor(i);
    }

    public static void main(String[] args) {
        Bitmap.launch((String[])args);
    }
}

