/*
 * Decompiled with CFR 0.152.
 */
package fractal;

public class Complex {
    private final double real;
    private final double imag;

    public Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public double getReal() {
        return this.real;
    }

    public double getImag() {
        return this.imag;
    }

    public double magnitude() {
        return Math.sqrt(this.magnitudeSquared());
    }

    public double magnitudeSquared() {
        double r = this.getReal();
        double i = this.getImag();
        return r * r + i * i;
    }

    public Complex add(Complex otherComplex) {
        double r0 = this.getReal();
        double i0 = this.getImag();
        double r1 = otherComplex.getReal();
        double i1 = otherComplex.getImag();
        return new Complex(r0 + r1, i0 + i1);
    }

    public Complex multiply(Complex otherComplex) {
        double r0 = this.getReal();
        double i0 = this.getImag();
        double r1 = otherComplex.getReal();
        double i1 = otherComplex.getImag();
        double r = r0 * r1 - i0 * i1;
        double i = r0 * i1 + i0 * r1;
        return new Complex(r, i);
    }

    public String toString() {
        return String.format("(%6.3f,%6.3f)", this.getReal(), this.getImag());
    }
}

