/*
 * Decompiled with CFR 0.152.
 */
package fractal;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;

public class Palette {
    private final Color c0 = Color.color((double)0.3, (double)0.2, (double)0.9);
    private final Color c1 = Color.color((double)0.4, (double)0.8, (double)0.2);
    private final List<Color> colors = new ArrayList<Color>();

    public Palette(int size) {
        for (int i = 0; i < size; ++i) {
            double t = (double)i / (double)(size - 1);
            if (i % 2 == 0) {
                t = 1.0 - t;
            }
            Color c = this.weightedAverage(this.c0, this.c1, t);
            this.colors.add(c);
        }
    }

    public int getSize() {
        return this.colors.size();
    }

    public Color getColor(int index) {
        return this.colors.get(index);
    }

    private double weightedAverage(double a, double b, double t) {
        return (1.0 - t) * a + t * b;
    }

    private Color weightedAverage(Color a, Color b, double t) {
        double r0 = a.getRed();
        double g0 = a.getGreen();
        double b0 = a.getBlue();
        double r1 = b.getRed();
        double g1 = b.getGreen();
        double b1 = b.getBlue();
        double red = this.weightedAverage(r0, r1, t);
        double green = this.weightedAverage(g0, g1, t);
        double blue = this.weightedAverage(b0, b1, t);
        return Color.color((double)red, (double)green, (double)blue);
    }
}

