package fractal;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;

// This class models a collection of colors.
public class Palette {

    // Define your own two colors here.
    // These are instance variables.
    private final Color c0 = Color.color(0.3, 0.2, 0.9);
    private final Color c1 = Color.color(0.4, 0.8, 0.2);

    private final List<Color> colors;

    // Here is a constructor.
    public Palette(int size) {
        this.colors = new ArrayList<>();
        
        // This code uses weighted averages to
        // produce colors. 
        // A different version of this constructor
        // might use random numbers to produce colors.
        // Other ways of producing colors are also
        // possible---experiment!
        for (int i = 0; i < size; i++) {
            // Compute a weight (a number between 0.0
            // and 1.0) for use in computing a weighted
            // average.
            double t = ((double) i) / (size - 1);

            // the even numbered colors are a blending
            // from c1 to c0
            // the odd numbered colors are a blending
            // from c0 to c1
            if (i % 2 == 0) {
                t = 1 - t;
            } // if

            Color c = weightedAverage(c0, c1, t);
            this.colors.add(c);
        } // for
    } // Palette()

    // This is an accessor method.
    public int getSize() {
        return this.colors.size();
    } // getSize()

    // This is an accessor method.
    // index should be in [0.0, size - 1],
    // where size is the number of colors
    // in this palette.
    public Color getColor(int index) {
        return this.colors.get(index);
    } // getColor( int )

    // This is a helper method.
    // It can only be called by the constructor
    // and other methods in this class.
    // t should have a value in [0.0, 1.0].
    private double weightedAverage(double a, double b,
            double t) {
        return (1 - t) * a + t * b;
    } // weightedAverage( double, double, double )

    // This is a helper method.
    // It can only be called by the constructor
    // and other methods in this class.
    // t should have a value in [0.0, 1.0].
    private Color weightedAverage(Color a, Color b,
            double t) {
        // Compute the weighted average of
        // 2 colors by computing the weighted
        // averages of the red components of the
        // 2 colors, the weighted averages of the
        // green components, and the weighted 
        // averages of the blue components.
        double r0 = a.getRed();
        double g0 = a.getGreen();
        double b0 = a.getBlue();

        double r1 = b.getRed();
        double g1 = b.getGreen();
        double b1 = b.getBlue();

        double red = weightedAverage(r0, r1, t);
        double green = weightedAverage(g0, g1, t);
        double blue = weightedAverage(b0, b1, t);

        return Color.color(red, green, blue);
    } // weightedAverage( Color, Color, double )

} // Palette
