
package bubbles;

import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.image.PixelWriter;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Bubbles extends Application {
    
    @Override
    public void start(Stage stage) {
        
        stage.setTitle("Bitmap");

        Canvas canvas = new Canvas(512, 512);
        GraphicsContext gc = canvas.getGraphicsContext2D();

        Pane root = new Pane();

        root.getChildren().add(canvas); 
        
        double x = 50;
        double y = 50;
        
        for(int i = 0; i < 4; i++) {
            Circle c = new Circle(x,y,50);
            c.draw(gc);
            x = x + 80;
            y -= 25;
        }
        
        Scene scene = new Scene(root, 512, 512);
        
        stage.setTitle("Hello World!");
        stage.setScene(scene);
        stage.show();
    } // start( Stage )

    private void draw(double x, double y, GraphicsContext gc) {
        double [] xPoints = new double [4];
        xPoints[0] = x;
        xPoints[1] = x;
        xPoints[2] = x+60;
        xPoints[3] = x+60;
        double [] yPoints = {y, y - 100, y - 140, y};
        
        gc.setFill(Color.CYAN);
        gc.fillPolygon(xPoints, yPoints, 4);  
    }
    
    public static void main(String[] args) {
        launch(args);
    } // main( String [] )
    
} // Bubbles
