package bubbles;

import javafx.scene.canvas.GraphicsContext;

public class Circle {

    private final double x;
    private final double y;
    private final double r;

    public Circle(double x, double y, double r) {
        this.x = x;
        this.y = y;
        this.r = r;
    }

    public double getX() {
        return x;
    }

    public double getY() {
        return y;
    }

    public double getR() {
        return r;
    }
    
    @Override
    public String toString(){
        return String.format(
        "Center = %6.3f,%6.3f Radius = %6.3f",
                this.getX(), this.getY(), this.getR()
        );
    }
    
    public void draw(GraphicsContext gc){
        double d = 2 * this.getR();
        gc.fillOval(x - this.getX(), y + this.getY(), d, d);
        
    }
    

}
