package landscape;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Landscape extends Application {

    private final int WIDTH = 512;
    private final int HEIGHT = 512;
    private final String TITLE = "Landscape";

    @Override
    public void start(Stage stage) {
        StackPane root = new StackPane();

        Scene scene = new Scene(root, WIDTH, HEIGHT);

        Canvas canvas = new Canvas(WIDTH, HEIGHT);

        drawPicture(canvas);

        root.getChildren().add(canvas);

        stage.setTitle(TITLE);
        stage.setScene(scene);
        stage.show();
    } // start( Stage )

    private void drawPicture(Canvas canvas) {
        GraphicsContext gc = canvas.getGraphicsContext2D();

        double w = canvas.getWidth();
        double h = canvas.getHeight();

        // draw the sky
        // do you want a different shade of blue?
        gc.setFill(Color.BLUE);
        // do you want to change the place where
        // ground meets sky?
        gc.fillRect(0, 0, w, 2 * h / 3);

        // draw the ground (grass)
        // do you want to different shade of green?
        gc.setFill(Color.GREEN);
        gc.fillRect(0, 2 * h / 3, w, h / 3);

        // draw the rest of the scene
        // what will your scene include?
        //   * houses or other kinds of buildings?
        //   * trees?
        //   * a flag on a flagpole?
        //   * a sun, moon, or clouds in the sky?
        //   * cars or other vehicles?
    } // drawPicture( Canvas )

    public static void main(String[] args) {
        launch(args);
    } // main( String [] )

} // Landscape
