/*
 * Decompiled with CFR 0.152.
 */
package news;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import news.MenuItemHandler;
import news.Story;

public class NewsReader
extends Application {
    private final int WIDTH = 768;
    private final int HEIGHT = 512;
    private final List<Story> stories = new ArrayList<Story>();
    private final Random rng = new Random();
    private final String DEUTSCHE_WELLE_NAME = "Deutsche Welle";
    private final String DEUTSCHE_WELLE_URL = "http://rss.dw.com/xml/rss-de-deutschlandentdecken";
    private final String GOETHE_INSTITUT_NAME = "Goethe Institut";
    private final String GOETHE_INSTITUT_URL = "https://www.goethe.de/de/feed/kul.rss";
    private final String HELMHOLTZ_ASSOC_NAME = "Helmholtz Association";
    private final String HELMHOLTZ_ASSOC_URL = "https://www.helmholtz.de/aktuell/presse_und_medien/mediathek/rss_feeds/technologie/";
    private final String SUEDDEUTSCHE_ZEITUNG_NAME = "S\u00fcddeutsche Zeitung";
    private final String SUEDDEUTSCHE_ZEITUNG_URL = "http://rss.sueddeutsche.de/rss/Topthemen";
    private final TextFlow textFlow = new TextFlow();

    public void init() {
        this.readChannel("http://rss.sueddeutsche.de/rss/Topthemen");
    }

    public void start(Stage stage) {
        BorderPane topLevel = new BorderPane();
        topLevel.getStyleClass().add((Object)"border-pane");
        topLevel.setCenter((Node)this.textFlow);
        MenuItemHandler handler = new MenuItemHandler(this);
        MenuBar menuBar = new MenuBar();
        Menu depthOfRecursion = new Menu("Channel");
        menuBar.getMenus().add((Object)depthOfRecursion);
        MenuItem channel0 = this.createMenuItem("Deutsche Welle", "http://rss.dw.com/xml/rss-de-deutschlandentdecken", handler);
        MenuItem channel1 = this.createMenuItem("Goethe Institut", "https://www.goethe.de/de/feed/kul.rss", handler);
        MenuItem channel2 = this.createMenuItem("Helmholtz Association", "https://www.helmholtz.de/aktuell/presse_und_medien/mediathek/rss_feeds/technologie/", handler);
        MenuItem channel3 = this.createMenuItem("S\u00fcddeutsche Zeitung", "http://rss.sueddeutsche.de/rss/Topthemen", handler);
        depthOfRecursion.getItems().addAll((Object[])new MenuItem[]{channel0, channel1, channel2, channel3});
        topLevel.setTop((Node)menuBar);
        Scene scene = new Scene((Parent)topLevel, 768.0, 512.0);
        scene.getStylesheets().add((Object)NewsReader.class.getResource("NewsReader.css").toExternalForm());
        stage.setTitle("Nachrichten aus Deutschland");
        stage.setScene(scene);
        stage.show();
    }

    private MenuItem createMenuItem(String name, String url, MenuItemHandler handler) {
        MenuItem result = new MenuItem(name);
        result.setId(url);
        result.setOnAction((EventHandler)handler);
        return result;
    }

    public void readChannel(String url) {
        boolean ok = false;
        try {
            URL feedUrl = new URL(url);
            SyndFeedInput input = new SyndFeedInput();
            XmlReader reader = new XmlReader(feedUrl);
            SyndFeed feed = input.build(reader);
            this.stories.clear();
            for (Object o : feed.getEntries()) {
                if (!(o instanceof SyndEntryImpl)) continue;
                SyndEntryImpl e = (SyndEntryImpl)o;
                String title = e.getTitle();
                String description = e.getDescription().getValue();
                String link = e.getLink();
                Story story = new Story(title, description, link);
                this.stories.add(story);
            }
            ok = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("ERROR: " + ex.getMessage());
        }
        if (!ok) {
            System.out.println();
            System.out.println("FeedReader reads and prints any RSS/Atom feed type.");
            System.out.println("The first parameter must be the URL of the feed to read.");
            System.out.println();
        }
        this.textFlow.getChildren().clear();
        for (Story story : this.stories) {
            Text title = new Text(story.getTitle() + "\n");
            Text description = new Text(story.getDescription() + "\n\n");
            this.textFlow.getChildren().addAll((Object[])new Node[]{title, description});
        }
    }

    public static void main(String[] args) {
        NewsReader.launch((String[])args);
    }
}

