package news;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.MenuItem;

public class MenuItemHandler implements EventHandler<ActionEvent> {

    private final NewsReader reader;

    public MenuItemHandler(NewsReader reader) {
        this.reader = reader;
    } // MenuItemHandler( Canvas )

    @Override
    public void handle(ActionEvent event) {
        MenuItem menuItem = (MenuItem) event.getSource();
        String id = menuItem.getId();
        this.reader.readChannel(id);
    } // handle( ActionEvent )

} // MenuItemHandler
